/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CFileImp.cpp,v 1.2 2000/01/09 09:00:04 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CFileImp.h"

_USING_PGP

// Class CFileImp member functions

CFileImp::CFileImp() : mIsOpened(FALSE), mOpenFlags(CFile::kNoFlags)
{
#if !PGP_EXCEPTIONS
	Status() = mPath.Status();
#endif	// !PGP_EXCEPTIONS
}

PGPBoolean 
CFileImp::IsFileInUseByReader(const char *path)
{
	pgpAssertStrValid(path);

#if PGP_EXCEPTIONS

	try
	{
		CFile	theFile;
		theFile.Open(path, CFile::kReadOnlyFlag | CFile::kDenyReadFlag);

		return FALSE;
	}
	catch (CComboError&)
	{
		return TRUE;
	}

#else	// !PGP_EXCEPTIONS

	CComboError	error;
	CFile		theFile;

	error = theFile.Open(path, CFile::kReadOnlyFlag | CFile::kDenyReadFlag);

	return error.IsError();

#endif	// PGP_EXCEPTIONS
}

PGPBoolean 
CFileImp::IsFileInUseByWriter(const char *path)
{
	pgpAssertStrValid(path);

#if PGP_EXCEPTIONS

	try
	{
		CFile	theFile;
		theFile.Open(path, CFile::kReadOnlyFlag);

		return FALSE;
	}
	catch (CComboError&)
	{
		return TRUE;
	}

#else	// !PGP_EXCEPTIONS

	CComboError	error;

	CFile	theFile;
	error = theFile.Open(path, CFile::kReadOnlyFlag);

	return error.IsError();

#endif	// PGP_EXCEPTIONS
}

PGPBoolean 
CFileImp::IsFileInUse(const char *path)
{
	return (IsFileInUseByReader(path) || IsFileInUseByWriter(path));
}
